package jp.mosp.common.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;

import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.action.AttendanceTotalAction;

import jp.mosp.workflow.dao.AmRouteDao;
import jp.mosp.workflow.dao.AmUnitDao;
import jp.mosp.workflow.dao.AttendanceRouteDao;
import jp.mosp.workflow.dao.PmAttendanceDao;
import jp.mosp.workflow.dto.AmUnitDto;
import jp.mosp.workflow.dto.AttendanceRouteDto;

public abstract class MosPWorkflowAction extends AttendanceTotalAction {

	// tB[h
	protected AmUnitDao unitDao;
	protected AmRouteDao routeDao;
	protected AttendanceRouteDao atRouteDao;
	
	protected PmAttendanceDao pmAttendDao;
	

	/**
	 * FpjbgDAȌ
	 * @throws Exception
	 */
	protected void prepareAmUnitDao() throws Exception {
		// DAO
		if (unitDao !=null) {
			return;
		}
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		unitDao = new AmUnitDao();
		unitDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * Fp[gDAȌ
	 * @throws Exception
	 */
	protected void prepareAmRouteDao() throws Exception {
		// DAO
		if (routeDao !=null) {
			return;
		}
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		routeDao = new AmRouteDao();
		routeDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * ΑӏFp[gDAȌ
	 * @throws Exception
	 */
	protected void prepareAttendanceRouteDao() throws Exception {
		// DAO
		if (atRouteDao !=null) {
			return;
		}
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		atRouteDao = new AttendanceRouteDao();
		atRouteDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * ΑӏFp[gDAȌ
	 * @throws Exception
	 */
	protected void preparePmAttendanceDao() throws Exception {
		// DAO
		if (pmAttendDao !=null) {
			return;
		}
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		pmAttendDao = new PmAttendanceDao();
		pmAttendDao.initDao(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * 󏳔FjbgR[hꗗiAM_UNITj
	 * @return@̏FjbgR[hXg
	 * @throws Exception
	 */
	protected String[][] getCurrentUnitArray() throws Exception {
		// DAȌ
		prepareAmUnitDao();
		String targetDate = util.convDateFormattedByHyphen(util.getSystemDate());
		// ̎擾
		List<AmUnitDto> listUnit = unitDao.findForCurrentUnitArray(targetDate);
		// z̍쐬		
		String[][] aryUnitList = new String[listUnit.size()][2];
		for (int i = 0; i < listUnit.size(); i++) {
			aryUnitList[i][0] = listUnit.get(i).getUnitCode();
			StringBuffer sb = new StringBuffer();
			sb.append(getKName(listUnit.get(i).getMain()));
			sb.append(CommonConst.SEPARATOR_DATE);
			sb.append(getKName(listUnit.get(i).getAgent()));
			aryUnitList[i][1] = sb.toString();
		}
		return aryUnitList;
	}

	/**
	 * p\ΑӏF[gꗗ
	 * @param kcode ΏێЈR[h
	 * @return 󏊑FjbgR[hXg
	 * @throws Exception
	 */
	protected String[][] getBelongRouteInfoArray(String kcode, Date targetDate) throws Exception {
		// DAȌ
		prepareAttendanceRouteDao();
		// ̎擾
		List<AttendanceRouteDto> listRoute = atRouteDao.findForAvailable(
				kcode,
				util.convDateFormattedByHyphen(getStartDate(targetDate))
		);
		String[][] aryRoute = new String[listRoute.size()][4];
		for (int i = 0; i < aryRoute.length; i++) {
			aryRoute[i][0] = listRoute.get(i).getSCode();
			aryRoute[i][1] = listRoute.get(i).getKCode();
			aryRoute[i][2] = listRoute.get(i).getLayer1();
			aryRoute[i][3] = listRoute.get(i).getLastLayer();
		}
		return aryRoute;
	}

	/**
	 * p\ΑӏF[gꗗ
	 * @param kcode ΏێЈR[h
	 * @return 󏊑FjbgR[hXg
	 * @throws Exception
	 */
	protected String[] getTargetRouteInfo(String kcode, Date targetDate) throws Exception {
		String[] aryRoute = new String[2];
		aryRoute[0] = "";
		aryRoute[1] = "";
		// ΑӏF[g擾
		String[][] aryRouteInfo = getBelongRouteInfoArray(mKihon.getKCode(), targetDate);
		// DAȌ
		MKihonDao mKihonDao = new MKihonDao();
		mKihonDao.initDao(cfg, cmd, aspUser, user, conn);
		// ͈͎擾
		int startDate = util.convDateToInteger(getStartDate(targetDate));
		// ΏێҎЈR[h
		String targetKCode = "";
		MKihonDto targetDto = mKihonDao.findForApprovalKCode(
				kcode,
				mKihon.getJCode(),
				mospUser.getDataLevel(),
				startDate
		);
		if (chkExistDto(targetDto)) {
			targetKCode = targetDto.getKCode();
		} 
		for (int i = 0; i < aryRouteInfo.length; i++) {
			// I猟
			if (aryRouteInfo[i][0].equals(getBelongSectionCode(targetKCode))) {
				aryRoute[0] = aryRouteInfo[i][2];
				aryRoute[1] = aryRouteInfo[i][3];
				break;		
			} else if (aryRouteInfo[i][1].equals(targetKCode)) {
				aryRoute[0] = aryRouteInfo[i][2];
				aryRoute[1] = aryRouteInfo[i][3];
				break;
			}
		}
		return aryRoute;
	}

}
